package net.w_horse.excelpojo.xml;

import net.w_horse.excelpojo.excel.cellseeker.PointedCellSeeker;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class PointedCellSeekerFactoryBean extends AbstractCellSeekerFactoryBean {
	private String position;

	@Override
	BeanDefinitionBuilder parse(Element element,
			CellSeekerFactoryBeanAcceptableXMLParser parser,
			ParserContext parserContext) {
		return parser.parse(element, this, parserContext);
	}

	@Override
	public Object getObject() throws Exception {
		PointedCellSeeker seeker = new PointedCellSeeker();
		seeker.setPosition(getPosition());
		seeker.setUse(getUse());
		seeker.setConverter(getConverter());

		return seeker;
	}

	@Override
	public Class<PointedCellSeeker> getObjectType() {
		return PointedCellSeeker.class;
	}

	public void setPosition(String position) {
		this.position = position;
	}

	public String getPosition() {
		return position;
	}

}
